/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.entangled;

import com.supermartijn642.core.block.BaseBlockEntity;
import com.supermartijn642.core.block.TickableBlockEntity;
import com.supermartijn642.entangled.Entangled;
import com.supermartijn642.entangled.EntangledConfig;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class EntangledBlockEntity
extends BaseBlockEntity
implements TickableBlockEntity {
    private boolean bound = false;
    private BlockPos boundPos;
    private ResourceKey<Level> boundDimension;
    private BlockState boundBlockState;
    private BlockEntity boundBlockEntity;
    private final int[] redstoneSignal = new int[]{0, 0, 0, 0, 0, 0};
    private final int[] directRedstoneSignal = new int[]{0, 0, 0, 0, 0, 0};
    private int analogOutputSignal = -1;
    private int callDepth = 0;

    public EntangledBlockEntity(BlockPos pos, BlockState state) {
        super(Entangled.tile, pos, state);
    }

    private void updateBoundBlockData(boolean forceLoad) {
        if (this.f_58857_ == null || this.f_58857_.f_46443_ || !this.bound || this.boundPos == null) {
            return;
        }
        Level level = this.getBoundDimension();
        if (level == null) {
            return;
        }
        ChunkSource chunkSource = level.m_7726_();
        if (chunkSource instanceof ServerChunkCache && ((ServerChunkCache)chunkSource).f_8330_ != Thread.currentThread()) {
            return;
        }
        boolean sendUpdate = false;
        if (level.m_46805_(this.boundPos) || forceLoad) {
            BlockState state = level.m_8055_(this.boundPos);
            BlockEntity entity = level.m_7702_(this.boundPos);
            int analogOutputSignal = state.m_60807_() ? state.m_60674_(level, this.boundPos) : 0;
            boolean signalChanged = false;
            for (Direction direction : Direction.values()) {
                int redstoneSignal = state.m_60746_((BlockGetter)level, this.boundPos, direction);
                int directRedstoneSignal = state.m_60775_((BlockGetter)level, this.boundPos, direction);
                if (redstoneSignal == this.redstoneSignal[direction.m_122411_()] && directRedstoneSignal == this.directRedstoneSignal[direction.m_122411_()]) continue;
                signalChanged = true;
                this.redstoneSignal[direction.m_122411_()] = redstoneSignal;
                this.directRedstoneSignal[direction.m_122411_()] = directRedstoneSignal;
            }
            if (state != this.boundBlockState || entity != this.boundBlockEntity || analogOutputSignal != this.analogOutputSignal || signalChanged) {
                this.boundBlockState = state;
                this.boundBlockEntity = entity;
                this.analogOutputSignal = analogOutputSignal;
                sendUpdate = true;
            }
        } else if (this.boundBlockEntity != null && this.boundBlockEntity.m_58901_()) {
            this.boundBlockEntity = null;
            sendUpdate = true;
        }
        if (sendUpdate) {
            this.dataChanged();
            this.f_58857_.m_46717_(this.f_58858_, this.m_58900_().m_60734_());
            this.f_58857_.m_46672_(this.f_58858_, this.m_58900_().m_60734_());
        }
    }

    public void update() {
        boolean forceLoad = this.boundBlockState == null || (this.boundBlockEntity != null ? this.boundBlockEntity.m_58901_() : this.boundBlockState.m_155947_()) || this.analogOutputSignal == -1;
        this.updateBoundBlockData(forceLoad);
    }

    public boolean isBound() {
        return this.bound;
    }

    @Nullable
    public BlockPos getBoundBlockPos() {
        return this.boundPos;
    }

    public ResourceKey<Level> getBoundDimensionIdentifier() {
        return this.boundDimension;
    }

    public BlockState getBoundBlockState() {
        return this.boundBlockState;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability) {
        if (this.bound && this.callDepth < 10) {
            if (this.boundBlockEntity == null ? this.boundBlockState == null || this.boundBlockState.m_155947_() : this.boundBlockEntity.m_58901_()) {
                this.updateBoundBlockData(false);
            }
            if (this.boundBlockEntity != null && !this.boundBlockEntity.m_58901_()) {
                ++this.callDepth;
                LazyOptional value = this.boundBlockEntity.getCapability(capability);
                --this.callDepth;
                return value;
            }
        }
        return LazyOptional.empty();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (this.bound && this.callDepth < 10) {
            if (this.boundBlockEntity == null ? this.boundBlockState == null || this.boundBlockState.m_155947_() : this.boundBlockEntity.m_58901_()) {
                this.updateBoundBlockData(false);
            }
            if (this.boundBlockEntity != null && !this.boundBlockEntity.m_58901_()) {
                ++this.callDepth;
                LazyOptional value = this.boundBlockEntity.getCapability(capability, facing);
                --this.callDepth;
                return value;
            }
        }
        return LazyOptional.empty();
    }

    public boolean bind(BlockPos pos, String dimension) {
        if (!this.canBindTo(pos, dimension)) {
            return false;
        }
        this.boundPos = pos == null ? null : new BlockPos((Vec3i)pos);
        this.boundDimension = dimension == null ? null : ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(dimension));
        this.bound = pos != null;
        this.boundBlockState = null;
        this.boundBlockEntity = null;
        this.f_58857_.m_46672_(this.m_58899_(), this.m_58900_().m_60734_());
        this.dataChanged();
        return true;
    }

    public boolean canBindTo(BlockPos pos, String dimension) {
        return pos == null && dimension == null || dimension.equals(this.f_58857_.m_46472_().m_135782_().toString()) ? EntangledConfig.maxDistance.get() == -1 || this.f_58858_.m_123314_((Vec3i)pos, (double)EntangledConfig.maxDistance.get().intValue() + 0.5) : EntangledConfig.allowDimensional.get();
    }

    private Level getBoundDimension() {
        if (this.boundDimension == null) {
            return null;
        }
        return this.f_58857_.f_46443_ ? (this.f_58857_.m_46472_() == this.boundDimension ? this.f_58857_ : null) : this.f_58857_.m_142572_().m_129880_(this.boundDimension);
    }

    private boolean isTargetLoaded() {
        if (this.f_58857_.f_46443_ || !this.bound) {
            return false;
        }
        Level level = this.f_58857_.m_46472_() == this.boundDimension ? this.f_58857_ : this.f_58857_.m_142572_().m_129880_(this.boundDimension);
        return level != null && level.m_46749_(this.boundPos);
    }

    public int getRedstoneSignal(Direction side) {
        if (!this.bound) {
            return 0;
        }
        if (this.isTargetLoaded() && this.callDepth < 10) {
            ++this.callDepth;
            Level level = this.getBoundDimension();
            this.redstoneSignal[side.m_122411_()] = level.m_8055_(this.boundPos).m_60746_((BlockGetter)level, this.boundPos, side);
            --this.callDepth;
            return Math.max(this.redstoneSignal[side.m_122411_()], 0);
        }
        return Math.max(this.redstoneSignal[side.m_122411_()], 0);
    }

    public int getDirectRedstoneSignal(Direction side) {
        if (!this.bound) {
            return 0;
        }
        if (this.isTargetLoaded() && this.callDepth < 10) {
            ++this.callDepth;
            Level level = this.getBoundDimension();
            this.directRedstoneSignal[side.m_122411_()] = level.m_8055_(this.boundPos).m_60775_((BlockGetter)level, this.boundPos, side);
            --this.callDepth;
            return Math.max(this.directRedstoneSignal[side.m_122411_()], 0);
        }
        return Math.max(this.directRedstoneSignal[side.m_122411_()], 0);
    }

    public int getAnalogOutputSignal() {
        if (!this.bound) {
            return 0;
        }
        if (this.isTargetLoaded() && this.callDepth < 10) {
            ++this.callDepth;
            Level level = this.getBoundDimension();
            this.analogOutputSignal = level.m_8055_(this.boundPos).m_60674_(level, this.boundPos);
            --this.callDepth;
            return Math.max(this.analogOutputSignal, 0);
        }
        return Math.max(this.analogOutputSignal, 0);
    }

    public void m_142466_(CompoundTag compound) {
        if (compound.m_128441_("bound")) {
            CompoundTag data = new CompoundTag();
            data.m_128379_("bound", compound.m_128471_("bound"));
            data.m_128405_("boundx", compound.m_128451_("boundx"));
            data.m_128405_("boundy", compound.m_128451_("boundy"));
            data.m_128405_("boundz", compound.m_128451_("boundz"));
            data.m_128359_("dimension", compound.m_128461_("dimension"));
            compound.m_128365_("data", (Tag)data);
        }
        super.m_142466_(compound);
    }

    protected CompoundTag writeData() {
        CompoundTag compound = new CompoundTag();
        if (this.bound) {
            compound.m_128379_("bound", true);
            compound.m_128405_("boundx", this.boundPos.m_123341_());
            compound.m_128405_("boundy", this.boundPos.m_123342_());
            compound.m_128405_("boundz", this.boundPos.m_123343_());
            compound.m_128359_("dimension", this.boundDimension.m_135782_().toString());
            compound.m_128405_("blockstate", Block.m_49956_((BlockState)this.boundBlockState));
            for (Direction direction : Direction.values()) {
                int index = direction.m_122411_();
                compound.m_128405_("redstoneSignal" + index, this.redstoneSignal[index]);
                compound.m_128405_("directRedstoneSignal" + index, this.directRedstoneSignal[index]);
            }
            compound.m_128405_("analogOutputSignal", this.analogOutputSignal);
        }
        return compound;
    }

    protected void readData(CompoundTag compound) {
        this.bound = compound.m_128471_("bound");
        if (this.bound) {
            this.boundPos = new BlockPos(compound.m_128451_("boundx"), compound.m_128451_("boundy"), compound.m_128451_("boundz"));
            this.boundDimension = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(compound.m_128461_("dimension")));
            this.boundBlockState = Block.m_49803_((int)compound.m_128451_("blockstate"));
            for (Direction direction : Direction.values()) {
                int index = direction.m_122411_();
                this.redstoneSignal[index] = compound.m_128451_("redstoneSignal" + index);
                this.directRedstoneSignal[index] = compound.m_128451_("directRedstoneSignal" + index);
            }
            this.analogOutputSignal = compound.m_128451_("analogOutputSignal");
        }
    }
}

